fkk = fkk or {}
if not fkk.teams then -- Make sure TeamSuite isn't loaded twice


fkk.teams = {
        version         = "3.01",
        debuging        = true,                        -- show alot of console outputs?
        overloadfuncs   = true,                         -- allow teamsuite to savely overwrite event functions?
        config          = {
                troubleshooting = false,                -- var not in use yet, so it doesn't matter if it is true or false
                admins          = {
                        "UNKNOWN",                      -- for listenserver
                        "fackelkind",                   -- me for listenserver
                        "STEAM_ID_LAN",                 -- for lan/listenserver
                        "STEAM_0:0:7001078"             -- me for dedicated server
                },
                file            = "lua/fkk/TeamSuite/teamsuite.cfg"     -- If you want to save the config elsewhere, do it here
        },
        isAdmin         = function (userid)             -- You can replace this var by your own adminfunction, if you have one
                userid = fkk.teams:getPlayersId (userid)
                return fkk.lib.table.in_table (userid, fkk.teams.config.admins)
        end
}

------------------------------------------------------------------------------------------------------------------------------------
-- END OF CONFIG
------------------------------------------------------------------------------------------------------------------------------------


-- (array) fkk.teams:defaultConfig ()
        function fkk.teams:defaultConfig ()
                local cfg = {
                        enabled         = true,
                        defaultteam     = TEAM_BLUE,
                        spawnprotection = 0,
                        dropweapons     = false,
                        teams = {
                                [TEAM_RED]              = {
                                        name                    = "Red Team",
                                        members                 = {},
                                        props                   = true
                                },
                                [TEAM_BLUE]             = {
                                        name                    = "Blue Team",
                                        members                 = {},
                                        props                   = true
                                },
                                [TEAM_GREEN]            = {
                                        name                    = "Green Team",
                                        members                 = {},
                                        props                   = true
                                },
                                [TEAM_YELLOW]           = {
                                        name                    = "Yellow Team",
                                        members                 = {},
                                        props                   = true
                                },
                                [TEAM_SPECTATOR]        = {
                                        name                    = "Spectator",
                                        members                 = {},
                                        props                   = false
                                }
                        }
                }
                if fkk.teams.addon then
                        for team, data in cfg.teams do
                                for addon, settings in fkk.teams.addon do
                                        -- if settings.default ~= nil and not fkk.lib.empty (settings.default) then
                                                cfg.teams[team][addon] = settings.default
                                        -- end
                                end
                        end
                end
                return cfg
        end

-- (bool) fkk.teams:loadConfig
        function fkk.teams:loadConfig ()
                local cfg
                if is_nil (self.config.file) then
                        if not self.initiated then
                                self:debug ("loadConfig: configfile not defined!", 1)
                        end
                        return nil, "error in config, configfile is not defined"
                elseif not _file.Exists (self.config.file) then
                        self.cfg = self:defaultConfig()
                        self:debug ("loadConfig: configfile doesn't exists. Creating a new one ...")
                        self:saveConfig()
                else
                        _RunString (_file.Read (self.config.file))
                        self.cfg = TeamSuite
                        if not is_table (self.cfg) then
                                self:debug ("loadConfig: configfile is malformed!!!", 1)
                                return false, "config is malformed"
                        else
                                if self.cfg.teams[0] ~= nil then
                                        self.cfg.teams[0] = nil
                                        self:saveConfig()
                                end
                                if self.addon then
                                        for team, data in self.cfg.teams do
                                                for addon, settings in self.addon do
                                                        if not self.cfg.teams[team][addon] and settings.default ~= nil then
                                                                self.cfg.teams[team][addon] = settings.default
                                                        end
                                                end
                                        end
                                end
                                self:debug ("loadConfig: \"" .. self.config.file .. "\"")
                        end
                end
                return true
        end

-- (void) fkk.teams:saveConfig
        function fkk.teams:saveConfig ()
                if not is_table (self.cfg) then
                        self:debug ("saveConfig: Unable to save config. Variable is not a table", 1)
                        return false, "not a table"
                else
                        self:debug ("saveConfig: to \"" .. self.config.file .. "\"")
                        _PrintMessageAll (HUD_PRINTTALK, "[TeamSuite] Config saved.")
                        _file.Write (self.config.file, "TeamSuite = " .. fkk.lib.table.tostring (self.cfg, true, false))
                        fkk.teams.admin.resendPanel()
                        return true
                end
        end

-- (void) fkk.teams:hookEvents
        function fkk.teams:hookEvents ()
                self.hooks = self.hooks or {}
                self:debug ("hooking events ...")
                if self.hooks["initialSpawn"] then
                        self:debug ("... eventPlayerInitialSpawn is already hooked.")
                else
                        self.hooks["initialSpawn"] = HookEvent ("eventPlayerInitialSpawn", function (userid) fkk.teams:setPlayersTeam (userid); fkk.teams.admin.resendPanel() end)
                        self:debug ("... +eventPlayerInitialSpawn")
                end
                if self.hooks["spawn"] then
                        self:debug ("... eventPlayerSpawn is already hooked.")
                else
                        self.hooks["spawn"] = HookEvent ("eventPlayerSpawn", function (userid) fkk.teams:setAttributes (userid) end)
                        self:debug ("... +eventPlayerSpawn")
                end
                if self.hooks["disconnect"] then
                        self:debug ("... eventPlayerDisconnect is already hooked.")
                else
                        self.hooks["disconnect"] = HookEvent ("eventPlayerDisconnect", function (name, userid) fkk.teams:clearPlayer (userid) end)
                        self:debug ("... +eventPlayerDisconnect")
                end
                if not fkk.teams.overloadfuncs then
                        if self.hooks["propSpawned"] then
                                self:debug ("... eventPlayerPropSpawned is already hooked.")
                        else
                                self.hooks["propSpawned"] = HookEvent ("eventPlayerPropSpawned", function (userid, prop) if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls"); _EntRemove (prop) end end)
                                self:debug ("... +eventPlayerPropSpawned")
                        end
                        if self.hooks["ragdollSpawned"] then
                                self:debug ("... eventPlayerRagdollSpawned is already hooked.")
                        else
                                self.hooks["ragdollSpawned"] = HookEvent ("eventPlayerRagdollSpawned", function (userid, prop) if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls"); _EntRemove (prop) end end)
                                self:debug ("... +eventPlayerRagdollSpawned")
                        end
                end
        end

-- (string) fkk.teams:getPlayersId ((int) Userid)
        function fkk.teams:getPlayersId (userid)
                local id
                if _IsDedicatedServer () then
                        return _PlayerInfo (userid, "networkid")
                end
                id = _PlayerInfo (userid, "steamlogin")
                if id then
                        return id
                end
                return _PlayerInfo (userid, "name")
        end

-- (void) fkk.teams:setToDefaultTeam ((int) Userid)
        function fkk.teams:setToDefaultTeam (userid)
                local defaultteam = self:getTeam (self.cfg.defaultteam)
                if defaultteam == false then
                        self:debug ("setToDefaultTeam: Unable to move player to defaultteam. Team is invalid or not found", 1)
                        return false, "invalid defaultteam"
                end
                self:debug ("setToDefaultTeam: " .. _PlayerInfo (userid, "name") .. " added to " .. self:getTeamName (defaultteam))
                _PlayerChangeTeam (userid, defaultteam)
                self.players[self:getPlayersId (userid)] = fkk.lib.table.copy (self.cfg.teams[defaultteam]) or {}
        end

-- (int) fkk.teams:getPlayersTeam ((int) Userid)
        function fkk.teams:getPlayersTeam (userid)
                if _PlayerInfo (userid, "connected") then
                        if is_table (self.cfg) then
                                for teamnumber, options in pairs (self.cfg.teams) do
                                        if options.members and is_table (options.members) and fkk.lib.table.in_table (self:getPlayersId (userid), options.members) then
                                                return teamnumber
                                        end
                                end
                        end
                        return false
                end
        end

-- (bool) fkk.teams:isAdminOnline (void)
        function fkk.teams:isAdminOnline ()
                for userid = 1, _MaxPlayers() do
                        if _PlayerInfo (userid, "connected") and fkk.teams.isAdmin (userid) then
                                return true
                        end
                end
                return false
        end

-- (void) fkk.teams:setPlayersTeam ((int) Userid)
        function fkk.teams:setPlayersTeam (userid)
                _PlayerChangeTeam (userid, TEAM_UNASSIGNED)
                if self.initialspawns == 0 then -- strange bug, teamnames have to be set after the first player has connected
                        self:addSpawnPoints() -- hehe fix the spawnpoint bug on non teamplay maps
                        self:setNames(true)
                end
                self.initialspawns = self.initialspawns + 1

                self.players = self.players or {}

                fkk.lib.player.ungod (userid)
                _EntSetMoveType (userid, MOVETYPE_WALK)

                if not self.cfg or self.cfg.enabled ~= true then
                        self:debug ("setPlayersTeam: Can not call this function while script is deactivated.")
                        return
                end

                if _PlayerInfo (userid, "connected") then
                        if is_table (self.cfg) then
                                for teamnumber, options in pairs (self.cfg.teams) do
                                        if options.members and is_table (options.members) and fkk.lib.table.in_table (self:getPlayersId (userid), options.members) then
                                                self:debug ("setPlayersTeam: " .. _PlayerInfo (userid, "name") .. " added to " .. self:getTeamName (teamnumber))
                                                _PlayerChangeTeam (userid, teamnumber)
                                                self.players[self:getPlayersId (userid)] = fkk.lib.table.copy (options)
                                                break
                                        end
                                end
                        end
                        if is_nil (self.players[self:getPlayersId (userid)]) then
                                self:setToDefaultTeam (userid)
                        end
                        if self.addon then
                                local options = self.players[self:getPlayersId (userid)]
                                for addonName, addonOptions in self.addon do
                                        if addonOptions and addonOptions.type then
                                                if addonOptions.type == "teamchange" then
                                                        addonOptions.func (userid)
                                                elseif addonOptions.type == "initial" then
                                                        -- if options[addonName] ~= nil then
                                                                self.addon[addonName].func (userid, options[addonName])
                                                        -- end
                                                end
                                        end
                                end
                        end
                end

                if _PlayerInfo (userid, "team") == TEAM_SPECTATOR then -- SPECTATOR FIX
                        fkk.timer.add (0.5, 1, _EntSetMoveType, userid, MOVETYPE_NOCLIP)
                        fkk.timer.add (0.5, 1, _PlayerRemoveAllWeapons, userid)
                end

        end

-- (void) fkk.teams:clearPlayer ((int) Userid)
        function fkk.teams:clearPlayer (userid)
                if self.players and self.players[self:getPlayersId (userid)] then
                        self.players[self:getPlayersId (userid)] = nil
                else
                        self:debug ("clearPlayer: Player not found")
                end
        end

-- (void) fkk.teams:setAttributes ((int) userid)
        function fkk.teams:setAttributes (userid)
                if not self.cfg or self.cfg.enabled ~= true then
                        self:debug ("setAttributes: Can not call this function while script is deactivated.")
                        return
                end

                local options
                local selectGravGun = 0.5
                if _PlayerInfo (userid, "connected") then
                        self.players[self:getPlayersId (userid)] = fkk.lib.table.copy (self.cfg.teams[_PlayerInfo (userid, "team")])
                        fkk.lib.player.ungod (userid)
                        if self.players and self.players[self:getPlayersId (userid)] then
                                options = self.players[self:getPlayersId (userid)]
                                if self.cfg.spawnprotection > 0 and options.hp and options.hp ~= -1 then
                                        fkk.lib.player.god (userid)
                                        fkk.timer.add (self.cfg.spawnprotection, 1, fkk.lib.player.ungod, userid)
                                        _PrintMessage (userid, HUD_PRINTTALK, "You are in godmode for " .. self.cfg.spawnprotection .. " seconds.")
                                end

                                if self.cfg.dropweapons ~= nil and self.cfg.dropweapons == false then
                                        _player.ShouldDropWeapon (userid, false)
                                else
                                        _player.ShouldDropWeapon (userid, true)
                                end
                                if options.props ~= nil and options.props == false then
                                        fkk.timer.add (0.2, 1, _PlayerRemoveWeapon, userid, "weapon_Tool")
                                        fkk.timer.add (0.21, 1, _PlayerRemoveWeapon, userid, "weapon_physcannon")
                                        fkk.timer.add (0.22, 1, _PlayerRemoveWeapon, userid, "weapon_physgun")
                                else
                                        fkk.timer.add (selectGravGun, 1, _PlayerSelectWeapon, userid, "weapon_physcannon")
                                end

                                if is_table (self.addon) then
                                        for attrib, data in pairs (self.addon) do
                                                if options[attrib] ~= nil and (data.type == nil or data.type == "spawn") then
                                                        data.func (userid, options[attrib])
                                                end
                                        end
                                end
                        else
                                self:debug ("setAttributes: Player \"" .. _PlayerInfo (userid, "name") .. "\" has no table.")
                                return false
                        end
                end
        end
-- (string) fkk.teams:getTeamName ((mixed) team)
        function fkk.teams:getTeamName (team)
                team = self:getTeam (team)
                if team == false then
                        return false, "team not found"
                end
                if self.cfg ~= nil and self.cfg.teams[team] ~= nil and self.cfg.teams[team].name ~= nil then
                        return self.cfg.teams[team].name
                else
                        return self:defaultTeamName (team)
                end
        end

-- (int) fkk.teams:getTeam ((mixed) team)
        function fkk.teams:getTeam (team)
                if is_integer (team) and team >= 0 and team <= 5 then
                        return team
                elseif is_integer (tonumber (team))  and tonumber (team) >= 0 and tonumber (team) <= 5 then
                        return tonumber (team)
                elseif is_string (team) then
                        team = string.lower (team)
                        if team == "red" or team == "team_red" then
                                return TEAM_RED
                        elseif team == "blue" or team == "team_blue" then
                                return TEAM_BLUE
                        elseif team == "yellow" or team == "team_yellow" then
                                return TEAM_YELLOW
                        elseif team == "green" or team == "team_green" then
                                return TEAM_GREEN
                        elseif team == "spec" or team == "team_spectator" or team == "spectator" or team == "team_spec" then
                                return TEAM_SPECTATOR
                        elseif self.cfg ~= nil then
                                for teamnumber, options in pairs (self.cfg.teams) do
                                        if options.name ~= nil and string.lower (options.name) == team then
                                                return teamnumber
                                        end
                                end
                        end
                end
                return false, "team \"" .. team .. "\" not found"
        end

-- (string) fkk.teams:defaultTeamName ((int) team)
        function fkk.teams:defaultTeamName (team)
                team = tonumber (team)
                if not is_integer (team) or team < 0 or team > 5 then
                        self:debug ("defaultTeamName: invalid teamnumber")
                        return false, "invalid teamnumber"
                else
                        team = team + 1
                end
                local teams = {
                        [1] = "Unassigned",
                        [2] = "Spectator",
                        [3] = "Blue Team",
                        [4] = "Yellow Team",
                        [5] = "Green Team",
                        [6] = "Red Team"
                }
                return teams[team]
        end

-- (string) fkk.teams:getTeamAsString ((int) CONST_TEAM)
        function fkk.teams:getTeamAsString (team)
                team = tonumber (team)
                if not is_integer (team) then
                        self:debug ("getTeamAsString: require argument #1 to be an integer. " .. type (team) .. " given.")
                        return nil, "argument must be an integer"
                else
                        team = team + 1
                end
                local teams = {
                        [1] = "TEAM_UNASSIGNED",
                        [2] = "TEAM_SPECTATOR",
                        [3] = "TEAM_BLUE",
                        [4] = "TEAM_YELLOW",
                        [5] = "TEAM_GREEN",
                        [6] = "TEAM_RED"
                }
                if teams[team] ~= nil then
                        return teams[team]
                end
                self:debug ("getTeamAsString: Team not found")
                return false, "team not found"
        end

-- (void) fkk.teams:setNames
        function fkk.teams:setNames (quite)
                if quite ~= true then
                        self:debug ("setting up teamnames ...")
                end
                for teamnumber = 0, 5 do
                        if self.cfg.teams[teamnumber] ~= nil and self.cfg.teams[teamnumber].name ~= nil then
                                if quite ~= true then
                                        self:debug ("... " .. self:getTeamAsString (teamnumber) .. " = " .. self.cfg.teams[teamnumber].name)
                                end
                                _TeamSetName (teamnumber, self.cfg.teams[teamnumber].name)
                        else
                                if quite ~= true then
                                        self:debug ("... " .. self:getTeamAsString (teamnumber) .. " = " .. self:defaultTeamName (teamnumber))
                                end
                                _TeamSetName (teamnumber, self:defaultTeamName (teamnumber))
                        end
                end
        end
-- (bool) fkk.teams.adminAccess ((int) Userid, (string) Action)
        function fkk.teams.adminAccess (userid, action)
                local cmd = fkk.lib.string.explode (action, " ", 2) or {}
                local args = fkk.lib.string.splitArgs (cmd[2], " ") or ""
                cmd = cmd[1]

                if cmd == nil or cmd == "info" then
                        if fkk.teams.cfg.enabled == true then
                                _PrintMessage (userid, HUD_PRINTCONSOLE, "[TeamSuite] v" .. fkk.teams.version .. " is enabled. (c) fackelkind")
                                fkk.teams:msg (userid, " v" .. fkk.teams.version .. " is enabled. (c) fackelkind")
                        else
                                _PrintMessage (userid, HUD_PRINTCONSOLE, "[TeamSuite] v" .. fkk.teams.version .. " is disabled. (c) fackelkind")
                                fkk.teams:msg (userid, " v" .. fkk.teams.version .. " is disabled. (c) fackelkind")
                        end
                elseif not fkk.teams.isAdmin (userid) then
                        return nil, "[TeamSuite] Sorry, you need to be an admin, to perform this command."
                else
                        if fkk.teams.admin["cmd_" .. cmd] then
                                return fkk.teams.admin["cmd_" .. cmd] (userid, unpack (args))
                        else
                                fkk.teams:msg (userid, "Unknown command \"" .. cmd .. "\".\nType \"!teamsuite help\" for a list of all commands")
                                return true
                        end
                        return true
                end
        end

        fkk.teams.admin = {}
        function fkk.teams.admin.cmd_help (userid, ...)
                function console (userid, text)
                        _PrintMessage (userid, HUD_PRINTCONSOLE, border (text))
                end
                function border (text)
                        return "= " .. text .. string.rep (" ", 76 - string.len (text)) .. "="
                end

                if arg[1] == nil or arg[1] == "" then
                        _PrintMessage (userid, HUD_PRINTCONSOLE, "")
                        _PrintMessage (userid, HUD_PRINTCONSOLE, "=== TeamSuite v" .. fkk.teams.version .. " Help " .. string.rep ("=", 80 - 21 - string.len (fkk.teams.version)))

                        console (userid, "Usage: !teamsuite <command> <args>")
                        console (userid, "Commands:")
                        console (userid, "   help <command>")
                        console (userid, "   enable")
                        console (userid, "   disable")
                        console (userid, "   config")
                        console (userid, "   add <user> <team>")
                        console (userid, "   remove <user>")
                        console (userid, "   set <option> <value>")
                        console (userid, "   clear")

                        _PrintMessage (userid, HUD_PRINTCONSOLE, string.rep ("=", 80))
                        _PrintMessage (userid, HUD_PRINTCONSOLE, "")

                        fkk.teams:msg (userid, "A helppage was printed to the console")
                        return true
                elseif arg[1] == "enable" then
                        fkk.teams:msg (userid, "Enables the TeamSuite.\nUsage: !teamsuite enable")
                        return true
                elseif arg[1] == "disable" then
                        fkk.teams:msg (userid, "Disables the TeamSuite.\nUsage: !teamsuite disable")
                        return true
                elseif arg[1] == "clear" then
                        fkk.teams:msg (userid, "Deletes the saved config and creates a new one with default values.\nUsage: !teamsuite clear")
                        return true
                elseif arg[1] == "add" then
                        fkk.teams:msg (userid, "Adds or moves a user to a specified team.\nUsage: !teamsuite add <username> <team>\nExample: !teamsuite add \"The Dog\" Members\nExample: !teamsuite add \"The Dog\" TEAM_GREEN")
                        return true
                elseif arg[1] == "remove" then
                        fkk.teams:msg (userid, "Removes a player from all teams.\nUsage: !teamsuite remove <username>\nExample: !teamsuite remove \"the dog\"")
                        return true
                elseif arg[1] == "set" then
                        fkk.teams:msg (userid, "Sets a global option.\nUsage: !teamsuite set <option> <value>\nValid options are: defaultTeam, spawnProtection, dropWeapons\nExample: !teamsuite set defaultTeam TEAM_SPECTATOR")
                        return true
                elseif arg[1] == "config" then
                        fkk.teams:msg (userid, "Shows the config in the consolee.\nUsage: !teamsuite config")
                        return true
                else
                        fkk.teams:msg (userid, "No help topics found for \"" .. arg[1] .. "\".\nType \"!teamsuite help\" to get a list of all commands")
                        return true
                end
        end

        function fkk.teams.admin.cmd_config (userid)
                function console (userid, text)
                        _PrintMessage (userid, HUD_PRINTCONSOLE, border (text))
                end
                function border (text)
                        return "= " .. text .. string.rep (" ", 77 - string.len (text)) .. "="
                end

                _PrintMessage (userid, HUD_PRINTCONSOLE, " ")
                _PrintMessage (userid, HUD_PRINTCONSOLE, "=== TeamSuite Config " .. string.rep ("=", 59))
                _PrintMessage (userid, HUD_PRINTCONSOLE, "=" .. string.rep (" ", 78) .. "=")

                local config = fkk.lib.table.copy (fkk.teams.cfg)

                for i = 1, 6 do
                        config.teams[fkk.teams:getTeamAsString (i - 1)] = config.teams[i - 1]
                        config.teams[i - 1] = nil
                end
                config = fkk.lib.string.explode (fkk.lib.table.tostring (config, true), "\n")
                config[1] = "[\"TeamSuite v" .. fkk.teams.version .. "\"] = " .. config[1]

                for i, v in config do
                        _PrintMessage (userid, HUD_PRINTCONSOLE, "=   " .. v .. string.rep (" ", 75 - string.len (v)) .. "=")
                end

                _PrintMessage (userid, HUD_PRINTCONSOLE, "=" .. string.rep (" ", 78) .. "=")
                _PrintMessage (userid, HUD_PRINTCONSOLE, string.rep ("=", 80))
                _PrintMessage (userid, HUD_PRINTCONSOLE, " ")
                fkk.teams:msg (userid, "A list was printed to the console.")
                return true
        end

        function fkk.teams.admin.cmd_add (userid, ...)
                if is_nil (arg[1]) or is_nil (arg[2]) then
                        fkk.teams.admin.help (userid, "add")
                        return nil
                end

                local playername, team = unpack (arg)
                local playerid = fkk.lib.player.find (playername)
                if string.sub (playername, 1, 1) == "#" then
                        playerid = tonumber (string.sub (playername, 2))
                end
                local teamid = fkk.teams:getTeam (team)
                local wasmoved = false

                if playerid == false then
                        fkk.teams:msg (userid, "User \"" .. playername .. "\" not found.")
                        return nil
                elseif is_table (playerid) then
                        fkk.teams:msg (userid, "There was mor then one match for \"" .. playername .. "\".\nMatches: " .. table.concat (playerid, ", "))
                        return nil
                elseif teamid == false then
                        fkk.teams:msg (userid, "Invalid team \"" .. tostring (team) .. "\".")
                        return nil
                end

                for teamnumber, data in pairs (fkk.teams.cfg.teams) do
                        if is_table (data.members) then
                                for index, member in pairs (data.members) do
                                        if member == fkk.teams:getPlayersId (playerid) then
                                                if teamid == teamnumber then
                                                        fkk.teams:msg (userid, _PlayerInfo (playerid, "name") .. " is already on team \"" .. fkk.teams:getTeamName (teamid) .. "\".")
                                                        return true
                                                end
                                                fkk.teams.cfg.teams[teamnumber].members[index] = nil
                                                wasmoved = teamnumber
                                                break
                                        end
                                end

                        end
                end

                fkk.teams.cfg.teams[teamid].members = fkk.teams.cfg.teams[teamid].members or {}
                table.insert (fkk.teams.cfg.teams[teamid].members, fkk.teams:getPlayersId (playerid))

                if wasmoved ~= false then
                        fkk.teams:msg (userid, "User \"" .. _PlayerInfo (playerid, "name") .. "\" was moved from team \"" .. fkk.teams:getTeamName (wasmoved) .. "\" to \"" .. fkk.teams:getTeamName (teamid) .. "\".")
                else
                        fkk.teams:msg (userid, "User \"" .. _PlayerInfo (playerid, "name") .. "\" was added to team \"" .. fkk.teams:getTeamName (teamid) .. "\".")
                end
                if userid ~= playerid then
                        fkk.teams:msg (playerid, _PlayerInfo (userid, "name") .. " set you to team \"" .. fkk.teams:getTeamName (teamid) .. "\".")
                end

                if fkk.teams.cfg.enabled == true then
                        fkk.teams:setPlayersTeam (playerid)
                        fkk.lib.player.respawn (playerid)
                end

                --fkk.teams.admin.resendPanel()
                --fkk.teams:saveConfig()
                return true
        end

        function fkk.teams.admin.cmd_clear (userid, ...)
                local oldConfig = "TeamSuite = " .. fkk.lib.table.tostring (fkk.teams.cfg, true)
                _file.Write (fkk.teams.config.file .. ".old", oldConfig)
                fkk.teams.cfg = fkk.teams:defaultConfig ()
                fkk.teams:msg (userid, "Config deleted, A back up was saved in \"" .. fkk.teams.config.file .. ".old\".")
                fkk.teams:saveConfig()
                fkk.teams:loadConfig()
                fkk.teams:enable()
        end

        function fkk.teams.admin.cmd_disable (userid)
                if fkk.teams.cfg.enabled == false then
                        fkk.teams:msg (userid, "Script is already disabled.")
                        return true
                end
                fkk.teams:msg (0, _PlayerInfo (userid, "name") .. " has disabled TeamSuite.\nSetting all players to Blue Team.")
                fkk.teams:disable()
                return true
        end

        function fkk.teams.admin.cmd_enable (userid)
                if fkk.teams.cfg.enabled == true then
                        fkk.teams:msg (userid, "Script is already enabled.")
                        return true
                end
                fkk.teams:msg (0, _PlayerInfo (userid, "name") .. " has enabled TeamSuite.\nSetting all players to their teams.")
                fkk.teams:enable()
                return true
        end

        function fkk.teams.admin.cmd_remove (userid, ...)
                local player = arg[1]
                local found = {}

                if not player then
                        fkk.teams.admin.help (userid, "remove")
                        return nil
                end
                local playerid = fkk.lib.player.find (player)

                if playerid == false then
                        fkk.teams:msg (userid, "User \"" .. playername .. "\" not found.")
                        return nil
                elseif is_table (playerid) then
                        fkk.teams:msg (userid, "There was mor then one match for \"" .. playername .. "\".\nMatches: " .. table.concat (playerid, ", "))
                        return nil
                end

                for teamnumber, data in fkk.teams.cfg.teams do
                        if is_table (data.members) and fkk.lib.table.in_table (fkk.teams:getPlayersId (playerid), data.members) then
                                for index, member in data.members do
                                        if member == fkk.teams:getPlayersId (playerid) then
                                                fkk.teams.cfg.teams[teamnumber].members[index] = nil
                                                table.insert (found, table.getn (found) + 1, fkk.teams:getTeamName (teamnumber))
                                        end
                                end
                        end
                end
                if table.getn (found) > 0 then
                        fkk.teams:msg (userid, "User \"" .. _PlayerInfo (playerid, "name") .. "\" was removed from: \"" .. table.concat (found, "\", \"") .. "\"")
                        --fkk.teams:saveConfig()
                        fkk.teams:setToDefaultTeam (playerid)
                        fkk.lib.player.respawn (playerid)
                else
                        fkk.teams:msg (userid, "User \"" .. _PlayerInfo (playerid, "name") .. "\" was not in any team.")
                end
        end
        fkk.teams.admin.cmd_del = fkk.teams.admin.cmd_remove
        fkk.teams.admin.cmd_delete = fkk.teams.admin.cmd_remove

        function fkk.teams.admin.noclip (userid, player, noclip)
                if noclip == true then
                        if _EntGetMoveType (player) ~= MOVETYPE_NOCLIP then
                                _EntSetMoveType (player, MOVETYPE_NOCLIP)
                                _PrintMessage (player, HUD_PRINTTALK, _PlayerInfo (userid, "name") .. " has enabled noclip for you. Type \"!noclip\" to disable it.")
                        end
                        fkk.teams.players[fkk.teams:getPlayersId (player)].noclip = true
                        return
                end
                if _EntGetMoveType (player) == MOVETYPE_NOCLIP then
                        _EntSetMoveType (player, MOVETYPE_WALK)
                        _PrintMessage (player, HUD_PRINTTALK, _PlayerInfo (userid, "name") .. " has disabled noclip on you.")
                end
                fkk.teams.players[fkk.teams:getPlayersId (player)].noclip = false
                return
        end

        function fkk.teams.admin.cmd_teleport (userid, player, who)
                player = tonumber (player)
                userid = tonumber (userid)
                local pos
                if who == "player" then
                        pos = _EntGetPos (userid)
                        pos.z = pos.z + 80
                        fkk.msg.talk (player, "[TeamSuite] " .. _PlayerInfo (userid, "name") .. " has teleported you.")
                        _EntSetPos (player, pos)
                elseif who == "user" then
                        pos = _EntGetPos (player)
                        pos.z = pos.z + 80
                        fkk.msg.talk (userid, "[TeamSuite] Teleported to " .. _PlayerInfo (player, "name") .. ".")
                        _EntSetPos (userid, pos)
                end
        end

        function fkk.teams.admin.cmd_exec (userid, ...)
                if arg[1] == "kick" then
                        fkk.teams.admin.kick (userid, arg[2])
                elseif arg[1] == "ban" then
                        fkk.teams.admin.ban (userid, arg[2])
                else
                        _RunString (table.concat (arg, " "))
                end
        end
        function fkk.teams.admin.kick (userid, player)
                _ServerCommand ("kickid " .. _PlayerInfo (player, "networkid") .. " You were kicked by " .. _PlayerInfo (userid, "name") .. "\n")
        end
        function fkk.teams.admin.ban (userid, player)
                _ServerCommand ("banid 5 " .. _PlayerInfo (player, "networkid") .. "\n")
                _ServerCommand ("kickid " .. _PlayerInfo (player, "networkid") .. " " .. _PlayerInfo (userid, "name") .. " banned you for 5 minutes\n")
        end

        function fkk.teams.admin.cmd_spawnmenu (userid, player, menutype)
                local menu = fkk.spawnMenu:New (userid, "[TeamSuite] Admin")
                menutype = menutype or "main"
                if is_nil (player) or not _PlayerInfo (player, "connected") then
                        fkk.teams:msg (userid, "This is not a valid player")
                        return nil
                else
                        menu:AddButton ("@TeamSuite v" .. fkk.teams.version .. " by fackelkind", "")
                        if fkk.teams.cfg.enabled == false then
                                menu:AddButton ("+Enable", "teamsuite enable")
                                menu:AddButton ("+Show Config", "teamsuite config")
                        else
                                menu:AddButton ("+Disable", "teamsuite disable")
                                menu:AddButton ("+Show Config", "teamsuite config; toggleconsole")
                                menu:AddButton ("+Save", "teamsuite exec fkk.teams:saveConfig()")
                                menu:AddButton ("+Load", "teamsuite exec fkk.teams:loadConfig()")
                        end
                        menu:AddButton ("@")
                        if menutype == "main" then
                                local userteam = fkk.teams:getPlayersTeam (player)
                                if userteam == false then
                                        menu:AddButton ("@" .. _PlayerInfo (player, "name") .. " (Guest)", "")
                                else
                                        menu:AddButton ("@" .. _PlayerInfo (player, "name"), "")
                                end
                                if userteam == false then
                                        menu:AddButton ("@Change player to team", "")
                                else
                                        menu:AddButton ("@Current team: " .. fkk.teams:getTeamName (userteam), "")
                                end
                                for i = 2, 6 do
                                        menu:AddButton ("+" .. fkk.teams:getTeamName (i-1), "teamsuite add #" .. player .. " " .. fkk.teams:getTeamAsString (i-1))
                                end
                                if userteam ~= false then
                                        menu:AddButton ("+Remove Team", "teamsuite remove \"" .. _PlayerInfo (player, "name") .. "\"")
                                end

                                menu:AddButton ("@Fun and Punishment ...", "")
                                menu:AddButton ("+Teleport", "teamsuite teleport " .. player .. " player")
                                menu:AddButton ("+Goto", "teamsuite teleport " .. player .. " user")
                                menu:AddButton ("+Kick", "teamsuite exec kick " .. player)
                                menu:AddButton ("+Kick", "teamsuite exec kick " .. player)
                                menu:AddButton ("+Ban", "teamsuite exec ban " .. player)
                                menu:AddButton ("+Kill", "teamsuite exec _PlayerKill (" .. player .. ")")
                                menu:AddButton ("+SilentKill", "teamsuite exec _PlayerSilentKill (" .. player .. ", 3, false)")
                                menu:AddButton ("+Respawn", "teamsuite exec _PlayerRespawn (" .. player .. ")")
                                menu:AddButton ("+RespawnOnPlace", "teamsuite exec fkk.lib.player.respawn (" .. player .. ")")
                                menu:AddButton ("+God", "teamsuite exec fkk.lib.player.god (" .. player .. ")")
                                menu:AddButton ("+Ungod", "teamsuite exec fkk.lib.player.ungod (" .. player .. ")")
                                if fkk.teams.addon["noclip"] then
                                        menu:AddButton ("+Enable Noclip", "teamsuite exec fkk.teams.admin.noclip (" .. userid .. ", " .. player .. ", true)")
                                        menu:AddButton ("+Disable Noclip", "teamsuite exec fkk.teams.admin.noclip (" .. userid .. ", " .. player .. ", false)")
                                end
                                menu:AddButton ("+Ungod", "teamsuite exec fkk.lib.player.ungod (" .. player .. ")")
                                menu:AddButton ("+Ungod", "teamsuite exec fkk.lib.player.ungod (" .. player .. ")")

                                menu:AddButton ("+Freeze", "teamsuite exec _PlayerFreeze (" .. player .. ", true)")
                                menu:AddButton ("+Unfreeze", "teamsuite exec _PlayerFreeze (" .. player .. ", false)")

                                menu:AddButton ("@Take care, the list can be huge ...", "")
                                menu:AddButton ("+Model", "teamsuite spawnmenu " .. player .. " models")
                                --fkk.spawnMenu:AddButton (menu, "+Sweps", "teamsuite spawnmenu " .. player .. " sweps")

                                menu:AddButton ("@", "")
                                menu:AddButton ("@", "")
                                menu:AddButton ("@Navi", "")
                                menu:AddButton ("+Back to main", "teamsuite exec fkk.teams.admin.resendPanel (" .. userid .. ")")

                        elseif menutype == "models" then
                                menu:AddButton ("@Select a playermodel ...", "")
                                local models = _file.Find ("models/player/*.mdl")
                                for i, model in models do
                                        local model = table.concat (fkk.lib.string.explode (model, ".", -1), ".")
                                        menu:AddButton ("+" .. model, "teamsuite exec _PlayerSetModel (" .. player .. ", 'models/player/" .. model .. ".mdl')")
                                end

                                menu:AddButton ("@", "")
                                menu:AddButton ("@", "")
                                menu:AddButton ("@Navi", "")
                                menu:AddButton ("+Back to main", "teamsuite exec fkk.teams.admin.resendPanel (" .. userid .. ")")
                                menu:AddButton ("+Back to " .. _PlayerInfo (player, "name"), "teamsuite spawnmenu " .. player .. " main")
                        end
                end
                menu:Send ()
        end

        function fkk.teams.admin.cmd_set (userid, ...)
                local option, value = unpack (arg)
                if is_nil (option) or is_nil (value) then
                        fkk.teams.admin.cmd_help (userid, "set")
                        return nil
                else
                        option = string.lower (tostring (option))
                        if option == "spawnprotection" then
                                if is_integer (tonumber (value)) then
                                        fkk.teams.cfg["spawnprotection"] = tonumber (value)
                                        if tonumber (value) == 0 then
                                                fkk.teams:msg (userid, "SpawnProtection turned off.\nConfig saved.")
                                        else
                                                fkk.teams:msg (userid, "SpawnProtection set to " .. tonumber (value) .. " seconds.\nConfig saved.")
                                        end
                                else
                                        fkk.teams:msg (userid, "cfg.spawnProtection: Value must be an integer!")
                                        return nil
                                end
                        elseif option == "defaultteam" then
                                option = fkk.teams:getTeam (value)
                                if option == false and is_number (tonumber (option)) then
                                        option = fkk.teams:getTeam (tonumber (option))
                                        if option == false then
                                                fkk.teams:msg (userid, "Team \"" .. tostring (value) .. "\" not found. DefaultTeam not changed.")
                                                return nil
                                        end
                                end
                                fkk.teams.cfg["defaultteam"] = option
                                fkk.teams:msg (userid, "DefaultTeam set to \"" .. fkk.teams:getTeamName (option) .. "\".")
                        elseif option == "dropweapons" then
                                value = tobool (value)
                                if is_bool (value) then
                                        fkk.teams.cfg["dropweapons"] = value
                                        fkk.teams:msg (userid, "DropWeapons set to " .. tostring (value) .. ".")
                                else
                                        fkk.teams:msg (userid, "cfg.dropWeapons: Value must a boolean.")
                                        return nil
                                end
                        else
                                fkk.teams:msg (userid, "Unknown option \"" .. tostring (option) .. "\".\nType \"!teamsuite help set\" valid options.")
                                return nil
                        end
                        -- fkk.teams:saveConfig()
                end
        end

        function fkk.teams.admin.resendPanel (send)
                local menu
                local player = {
                        {}, {}, {}, {}, {}, default = {}
                }
                local usersteam
                for userid = 1, _MaxPlayers() do
                        if _PlayerInfo (userid, "connected") then
                                usersteam = fkk.teams:getPlayersTeam (userid)
                                if not usersteam then
                                        table.insert (player.default, userid)
                                else
                                        table.insert (player[usersteam ], userid)
                                end
                        end
                end

                --if send == nil and fkk.teams.isAdmin (userid) then
                --        fkk.spawnMenu.Send (menu, userid)
                --        return
                --end
                for userid = 1, _MaxPlayers() do
                        if _PlayerInfo (userid, "connected") and fkk.teams.isAdmin (userid) then
                                menu = fkk.spawnMenu:New (userid, "[TeamSuite] Admin")
                                menu:AddButton ("@TeamSuite v" .. fkk.teams.version .. " by fackelkind", "")
                                if fkk.teams.cfg.enabled == false then
                                        menu:AddButton ("+Enable", "teamsuite enable")
                                        menu:AddButton ("+Show Config", "teamsuite config")
                                else
                                        menu:AddButton ("+Disable", "teamsuite disable")
                                        menu:AddButton ("+Show Config", "teamsuite config; toggleconsole")
                                        menu:AddButton ("+Save", "teamsuite exec fkk.teams:saveConfig()")
                                        menu:AddButton ("+Load", "teamsuite exec fkk.teams:loadConfig()")

                                        menu:AddButton ("@")
                                        menu:AddButton ("@Playerlist:")


                                        if not fkk.lib.empty (player.default) then
                                                menu:AddButton ("@Default Team (" .. fkk.teams:getTeamName (fkk.teams.cfg.defaultteam) .. ")")
                                                for i, userid in player.default do
                                                        menu:AddButton ("+" .. _PlayerInfo (userid, "name"), "teamsuite spawnmenu " .. userid .. " main")
                                                end
                                        end
                                        for i = 1, 5 do
                                                if not fkk.lib.empty (player[i]) then
                                                        menu:AddButton ("@" .. fkk.teams:getTeamName (i))
                                                        for _, userid in player[i] do
                                                                menu:AddButton ("+" .. _PlayerInfo (userid, "name"), "teamsuite spawnmenu " .. userid .. " main")
                                                        end
                                                end
                                        end
                                end
                                menu:Send ()
                        end
                end
        end

-- (void) fkk.teams:debug ((string) text, (bool) force)
        function fkk.teams:debug (message, force)
                if self.debuging == true or force ~= nil then
                        _Msg ("[fkk.teams] " .. tostring (message) .. "\n")
                end
        end

-- (void) fkk.teams:msg ((int) Userid, (string) Message)
        function fkk.teams:msg (userid, text)
                if is_nil (userid) then
                        self:debug ("msg: needs to arguments (userid, text)")
                        return
                elseif is_nil (text) then
                        text = userid
                        userid = 0
                end
                text, err = fkk.lib.string.explode (tostring (text), "\n")

                if userid == 0 then
                        _PrintMessageAll (HUD_PRINTTALK, "[TeamSuite] " .. text[1])
                        _PrintMessageAll (HUD_PRINTCONSOLE, "[TeamSuite] " .. text[1])
                else
                        _PrintMessage (userid, HUD_PRINTTALK, "[TeamSuite] " .. text[1])
                        _PrintMessage (userid, HUD_PRINTCONSOLE, "[TeamSuite] " .. text[1])
                end
                if table.getn (text) > 1 then
                        for i = 2, table.getn (text) do
                                if userid == 0 then
                                        _PrintMessageAll (HUD_PRINTTALK, text[i])
                                        _PrintMessageAll (HUD_PRINTCONSOLE, text[i])
                                else
                                        _PrintMessage (userid, HUD_PRINTTALK, text[i])
                                        _PrintMessage (userid, HUD_PRINTCONSOLE, text[i])
                                end
                        end
                end
        end

-- (void) fkk.teams:setServerVar ((int) Status)
        function fkk.teams:setServerVar (status)
                status = status or 1
                if status ~= 0 and status ~= 1 then
                        self:debug ("setServerVar: argument must be 1 or 0")
                        return nil, "invalid argument"
                end
                self:debug ("setServerVar: gm_sv_teamplay " .. status)
                _ServerCommand("gm_sv_teamplay " .. status .. "\n")
                _ServerCommand("gm_sv_setrules\n")
        end

-- (void) fkk.teams:addSpawnPoints()
        function fkk.teams:addSpawnPoints() -- No more ERROR: Couldn't find team spawnpoint for team XXXXXX :D
                local newSpawnPoint
                local oldSpawnPoint = _EntitiesFindByClass ("gmod_player_start")
                if table.getn (oldSpawnPoint) == 0 then
                        oldSpawnPoint = _EntitiesFindByClass ("info_player_start")
                end

                for i in oldSpawnPoint do
                        for team = 2, 5 do
                                newSpawnPoint = _EntCreate ("gmod_player_start")
                                _EntSetPos (newSpawnPoint, _EntGetPos (oldSpawnPoint[i]))
                                _EntSetAng (newSpawnPoint, _EntGetAng (oldSpawnPoint[i]))
                                _EntFire (newSpawnPoint, "addoutput", "spawnflags " .. fkk.lib.math.dec2bin (team - 1), 0)
                                _EntSpawn (newSpawnPoint)
                        end
                end
        end

        function fkk.teams:disable ()
                self:loadConfig()
                self.cfg.enabled = false
                self:saveConfig()
                self:setServerVar (0)

                for userid = 1, _MaxPlayers() do
                        if _PlayerInfo (userid, "connected") then
                                for addon, data in self.addon do
                                        if data.func ~= nil then
                                                data.func (userid, false)
                                        end
                                end
                        end
                end
                for team = 0, 5 do
                        self:debug ("teamName: " .. self:getTeamName (team) .. " => " .. self:defaultTeamName (team))
                        _TeamSetName (team, self:defaultTeamName (team))
                end
                if self.hooks and fkk.lib.table.count (self.hooks) > 0 then
                        for hookname, hookid in self.hooks do
                                self:debug ("unHookEvent: " .. hookname)
                                UnHookEvent (hookid)
                                self.hooks[hookname] = nil
                        end
                end
                self.hooks = nil

                if fkk.teams.overloadfuncs == true then
                        self:debug ("restoring overloaded function ...")
                        self:debug ("... eventPlayerSpawnProp")
                        eventPlayerSpawnProp = fkk.teams.eventPlayerSpawnProp
                        self:debug ("... eventPlayerSpawnRagdoll")
                        eventPlayerSpawnRagdoll = fkk.teams.eventPlayerSpawnRagdoll
                        self:debug ("... eventPlayerDuplicateProp")
                        eventPlayerDuplicateProp = fkk.teams.eventPlayerDuplicateProp
                        self:debug ("... eventPlayerDuplicateRagdoll")
                        eventPlayerDuplicateRagdoll = fkk.teams.eventPlayerDuplicateRagdoll
                        self:debug ("... onPlayerRemove")
                        onPlayerRemove = fkk.teams.onPlayerRemove
                end

                for userid = 1, _MaxPlayers() do
                        if _PlayerInfo (userid, "connected") and _PlayerInfo (userid, "team") ~= TEAM_BLUE then
                                _PlayerChangeTeam (userid, TEAM_BLUE)
                                fkk.lib.player.respawn (userid)
                        end
                end
        end
        function fkk.teams:enable ()
                self.cfg.enabled = true
                self:saveConfig()
                if _GetConVar_Bool("gm_sv_teamplay") == false then
                        self:setServerVar (1)
                        self.gm_sv_teamplay = 0
                end
                self:setNames()
                if self.cfg.defaultteam == nil then
                        self:debug ("defaultTeam: NOT SET!", 1)
                elseif self:getTeam (self.cfg.defaultteam) == false then
                        self:debug ("defaultTeam: NOT VALID / EXISTING!", 1)
                else
                        self:debug ("defaultTeam: +" .. self:getTeamName (self:getTeam (self.cfg.defaultteam)) .. " (" .. self:getTeamAsString (self:getTeam (self.cfg.defaultteam)) .. ") = OK")
                end
                self:hookEvents()

                -- lets overwrite some functions
                if fkk.teams.overloadfuncs == true then
                        self:debug ("Overloading function ...")

                        fkk.teams.eventPlayerSpawnProp = eventPlayerSpawnProp
                        fkk.teams.eventPlayerSpawnRagdoll = eventPlayerSpawnRagdoll
                        fkk.teams.eventPlayerDuplicateProp = eventPlayerDuplicateProp
                        fkk.teams.eventPlayerDuplicateRagdoll = eventPlayerDuplicateRagdoll
                        fkk.teams.onPlayerRemove = onPlayerRemove

                        function eventPlayerSpawnProp (userid, prop)
                                if fkk.teams.eventPlayerSpawnProp (userid, prop) == false then
                                        return false
                                end
                                if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then
                                        _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls")
                                        return false
                                end
                                return true
                        end
                        self:debug ("... eventPlayerSpawnProp")

                        function eventPlayerSpawnRagdoll (userid, prop)
                                if fkk.teams.eventPlayerSpawnRagdoll (userid, prop) == false then
                                        return false
                                end
                                if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then
                                        _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls")
                                        return false
                                end
                                return true
                        end
                        self:debug ("... eventPlayerSpawnRagdoll")

                        function eventPlayerDuplicateProp (userid, prop)
                                if fkk.teams.eventPlayerDuplicateProp (userid, prop) == false then
                                        return false
                                end
                                if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then
                                        _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls")
                                        return false
                                end
                                return true
                        end
                        self:debug ("... eventPlayerDuplicateProp")

                        function eventPlayerDuplicateRagdoll (userid, prop)
                                if fkk.teams.eventPlayerDuplicateRagdoll (userid, prop) == false then
                                        return false
                                end
                                if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then
                                        _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls")
                                        return false
                                end
                                return true
                        end
                        if not self.initiated then
                                self:debug ("... eventPlayerDuplicateRagdoll")
                        end

                        function onPlayerRemove (userid, prop)
                                if fkk.teams.onPlayerRemove (userid, prop) == false then
                                        return false
                                end
                                if fkk.teams.players[fkk.teams:getPlayersId (userid)] and fkk.teams.players[fkk.teams:getPlayersId (userid)].props == false then
                                        _PrintMessage (userid, HUD_PRINTTALK, "Your team (" .. fkk.teams:getTeamName (_PlayerInfo (userid, "team")) .. ") is not allowed to create/remove props/ragdolls")
                                        return false
                                end
                                return true
                        end
                        if not self.initiated then
                                self:debug ("... onPlayerRemove")
                        end
                end
                if self.initiated then
                        self:debug ("move players to their teams")
                        for userid = 1, _MaxPlayers() do
                                if _PlayerInfo (userid, "connected") then
                                        self:setPlayersTeam (userid)
                                        fkk.lib.player.respawn (userid)
                                end
                        end
                        -- self:saveConfig()
                end
        end

-- (void) fkk.teams:init
        function fkk.teams:init ()
                if not CHATCOMMAND then
                        _OpenScript ("lua/fkk/AaAaA_ChatCommands.lua")
                end

                self.cache = {}
                self.userfunc = {}
                self.initialspawns = 0

                self.addon = {}
                self.cache.addons = _file.Find ("lua/fkk/TeamSuite/addons/*.lua")

                if table.getn (self.cache.addons) > 0 then
                        self:debug ("loading addons ...")
                        for _, addon in self.cache.addons do
                                self:debug ("... " .. string.sub (addon, 1, string.len (addon) - 4))
                                _OpenScript ("lua/fkk/TeamSuite/addons/" .. addon)
                        end
                end

                if not self.cfg then
                        self:loadConfig()
                end
                self.hooks = {initialSpawn = HookEvent ("eventPlayerInitialSpawn", function (userid) fkk.teams:setPlayersTeam (userid); fkk.teams.admin.resendPanel() end)}

                if CHATCOMMAND then
                        if CHATCOMMANDs["!teamsuite"] ~= nil then
                                if not self.initiated then
                                        self:debug ("chatCommand: !teamsuite already hooked.")
                                end
                        else
                                CHATCOMMAND ("!teamsuite", fkk.teams.adminAccess, "[TeamSuite] Unknown command. Type !teamsuite help to get a list of all avaible commands.")
                                if not self.initiated then
                                        self:debug ("chatCommand: + !teamsuite")
                                end
                        end
                else
                        if not self.initiated then
                                self:debug ("chatCommand: script wan't loaded yet.")
                        end
                end

                if not self.initiated then
                        self:debug ("conCommand: + teamsuite")
                end
                CONCOMMAND ("teamsuite", fkk.teams.adminAccess, "[TeamSuite] Unknown command. Type !teamsuite help to get a list of all avaible commands.")

                if self.cfg.enabled == true then
                        self:enable()
                else
                        if not self.initiated then
                                self:debug ("init: script is deactivated.")
                        end
                end

                self.initiated = true
        end

fkk.teams:init()


end -- /End making sure TeamSuite isn't loaded twice